package 
{
	import flash.display.*;
	import flash.media.*;
	import flash.events.*;
	import flash.ui.Mouse;
	//importing classes
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.text.AntiAliasType;
	import flash.filters.*;
	import flash.net.*;
	import flash.utils.*;
	import flash.geom.*;
	import flash.ui.*;
	import caurina.transitions.*;
	import caurina.transitions.properties.FilterShortcuts;
	import caurina.transitions.properties.DisplayShortcuts;
	
	
	public class Scroller extends MovieClip
	{
		
		public var source:DisplayObject = null;
		
		private var i:int = 0; //for the 'for' instruction
		private var buttonPos:int = 0;
		private var buttonCon:MovieClip = new MovieClip();
		private var w:int = 0;
		private var h:int = 0;
		private var viewIndex:int = 0;
		private var scrollOffest:int = 40;
		private var blurScroll:String = "on";//choose on/off if you want blur scroll
		public function Scroller(psource:DisplayObject,pw:int,ph:int)
		{
			w = pw;
			h = ph;
			DisplayShortcuts.init(); 
			
			FilterShortcuts.init();
			
			source = psource;
			
			//we set up the mask
			var bg:Sprite = new Sprite();
				bg.graphics.beginFill(0x000000);
				bg.graphics.drawRect(0, 0, w, h);
				addChild(bg);
			
				
			source.mask = bg;
			addChild(source);
			
			
			
			//choose between mouse move and enter frame ghandling
			if(source.height>ph)
			//addEventListener(MouseEvent.MOUSE_MOVE, handleMouse);
			addEventListener(Event.ENTER_FRAME, handleMouse);
		}
		public function handleMouse(e:Event)
		{
			//the function which moves the source depending on mouse
			if (mouseY > 0 && mouseY < h && mouseX > 0 && mouseX < w)
			{
			viewIndex = (mouseY / h) * -(source.height - h + scrollOffest * 2 + 100) + scrollOffest + 50;
			if (viewIndex > 0) viewIndex = 0;
			if (viewIndex < -(source.height-h + 50)) viewIndex = -(source.height-h + 50);
			
			Tweener.addTween(source, { y:viewIndex, transition:"easeOutSine", rounded:true, time:.3 } );
			
			//set up blur scrolling
			if (blurScroll == "on")
			{
				Tweener.addTween(source, { _Blur_blurY:Math.abs(viewIndex-source.y)/5, time:.2 } );
				
			}
			}
			else
			{
				Tweener.addTween(source, { _Blur_blurY:0, time:.2 } );
			}
		}
		public function updateScroll()
		{
			h = stage.stageHeight;
			
			if(source.height<=h)
			removeEventListener(Event.ENTER_FRAME, handleMouse)
			else
			{
				addEventListener(Event.ENTER_FRAME, handleMouse)
			}
			Tweener.addTween(source, { y:0, transition:"easeOutSine", rounded:true, time:.3 } );
			
		}
		
		


	}
}